<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult">
	<xsl:output method="text"  version="1.0" encoding="UTF-8" indent="no"/>
<!--
File: fixed_width.xsl

Transforms data exported in the FMPXMLRESULT grammar into a stream
of data with fixed column widths. Fields shorter than the set width
are padded with defined characters. The default behavior is to pad 
with spaces, but this may be changed in the variable 'padding_character'
below. Data in any field exceeding the length defined in the variable
'columnwidth' will be truncated (removed) from the final output. Note
that there are no delimiters between outputted fields, the data runs
together in one continuous stream for each record.

For example, a database such as this:

Field A           Field B     Field C
Data in field A   One         Another
The               Next        Again
11                32          FileMaker

when exported with a 'columnwidth' of four (4) will appear
like this:

============
DataOne Anot
The NextAgai
11  32  File

Change the value of the variable "columnwidth" below to adjust
column width.

Note that the function substring(string, start, length) is one 
based, not zero based.

===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in 
  the documentation and/or other materials provided with the
  distribution.

* Neither the name of the FileMaker, Inc. nor the names of its 
  contributors may be used to endorse or promote products derived
  from this software without specific prior written
  permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
    
===============================================================
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
			<xsl:for-each select="fmp:COL">
				<xsl:choose>
					<xsl:when test="string-length(fmp:DATA) &lt; $columnwidth">
						<xsl:value-of select="fmp:DATA"/>
						<xsl:call-template name="pad_output">
							<xsl:with-param name="numspaces" select="$columnwidth - string-length(fmp:DATA)"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring(fmp:DATA,1,$columnwidth)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:value-of select="$newline"/>
		</xsl:for-each>
	</xsl:template>
	
<!--
Template: pad_output
	
Recursive function that accepts a parameter of number of padding
characters to output.
-->
	<xsl:template name="pad_output">
		<xsl:param name="numspaces" select="0"/>
		<xsl:if test="$numspaces &gt; 0">
			<xsl:value-of select="$padding_character"/>
			<xsl:call-template name="pad_output">
				<xsl:with-param name="numspaces" select="$numspaces - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
<!--
This variable controls the uniform column width of every field.
-->
	<xsl:variable name="columnwidth">
		<xsl:text>17</xsl:text>
	</xsl:variable>
<!--
The default is to pad fields shorter than "columnwidth" with spaces
but this can be changed to any character.
-->
	<xsl:variable name="padding_character">
		<xsl:text> </xsl:text>
	</xsl:variable>
<!--
The output method of "text" will handle the carriage return between the
xsl:text tags below. This may also be changed to any character and is
especially useful when the output is to be machine "read".
-->	
<xsl:variable name="newline">
<xsl:text>
</xsl:text>
</xsl:variable>
</xsl:stylesheet>
